<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

// General utility functions

function cmtk_LogError($err_msg, $script, $line) {
    unset($ERRORS);
    if (isset($_SESSION["ERRORS"])) {
        $ERRORS = $_SESSION["ERRORS"];
    }
    if (!isset($ERRORS)) {
        $ERRORS = array();
    }

    $ERRORS[] = "<b>" . date("F j, Y, g:i:s a") .
         "</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Error:</b> $err_msg" .
         "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Script:</b> " .
         "$script - <b>Line:</b> $line";
    $_SESSION["ERRORS"] = $ERRORS;
}

function cmtk_GetErrorString() {
    $ret = "";
    $ERRORS = $_SESSION["ERRORS"];
    if (!isset($ERRORS)) {
        $ERRORS = array();
    }
    $ret = "\r\n<div style='background-color: #dddddd; border: 1px solid #000000;'>" .
        "<font size=+2><B>Message Log:</B></font>\r\n<hr />\r\n"
    . implode("\r\n<hr />\r\n", array_reverse($ERRORS)) . "\r\n</div>\r\n";
    return $ret;
}

function cmtk_GetPageRenderTimingString() {
    global $cmtk_include_start_timer;
    $cmtk_include_end_timer = cmtk_GetMicrotime();

    $ret = "\r\n<div style='background-color: #dddddd; border: 1px solid #000000;'>" .
        "<font size=+2><B>Page Render Timing Log:</B></font>\r\n<hr />\r\n"
    . "\r\nTotal page render time: " . ($cmtk_include_end_timer - $cmtk_include_start_timer) . "\r\n</div>\r\n";
    return $ret;
}

function cmtk_GetMicrotime(){
	list($usec, $sec) = explode(" ",microtime());
	return ((float)$usec + (float)$sec);
}

function cmtk_DOMinnerHTML($element)
{
    $innerHTML = "";
    $children = $element->childNodes;
    foreach ($children as $child)
    {
        $tmp_dom = new DOMDocument();
        $tmp_dom->appendChild($tmp_dom->importNode($child, true));
        $innerHTML.=trim($tmp_dom->saveHTML());
    }
    return $innerHTML;
} 

function cmtk_GetReqValue($val_name, $default_value = "") {
	if (!isset($_REQUEST[$val_name])) {
		return $default_value;
	}
	return trim($_REQUEST[$val_name]);
}



function cmtk_GenerateRandomHash($hash_size) {
	$ret = "";
	for ($i = 0; $i < $hash_size; $i++) {
		$t = rand(1,3);
		switch($t) {
			case 1:
				$ret .= chr(rand(48,57));
				break;
			case 2:
				$ret .= chr(rand(65,90));
				break;
			case 3:
				$ret .= chr(rand(97,122));
				break;
			default:
				$ret .= "ERR";
				break;
		}
	}
	return $ret;
}


function cmtk_GetHumanReadableSize($size) {
	// Bytes
	if ($size < 1024) { return number_format($size, 2) . "B"; }
	// Kilo
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "KB"; }
	// Meg
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "MB"; }
	// Gig
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "GB"; }
	// Terra
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "TB"; }
	// Peta
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "PB"; }
	// Exa
	$size /= 1024;
	if ($size < 1024) { return number_format($size, 2) . "EB"; }

	return number_format($size, 2) . "EB";
}


function cmtk_GetUniqueID() {
    $ret = "";
    if (!function_exists('uniqid')) {
        // Use the random hash function if our unique id function isn't available
        $ret = cmtk_GenerateRandomHash(50);
    } else {
        $ret = uniqid(cmtk_GetConfigValue('uniqid_prefix', 'cmtk_'), true);
    }

    return $ret;
}

function cmtk_IncludeFiles($path) {
	if (is_file($path)) { return array(); }
	@$d = dir($path);
	if ($d === false) { return array(); }
	$entries = array();
	while (false !== ($entry = $d->read())) {
		if ($entry != "." && $entry != ".." && is_file($path . "/" . $entry) && $entry != "script_config.php" &&  strtolower(substr($entry, -4,4)) == ".php") {
			// DEAL WITH FILES
			array_push($entries, $entry);
			//print "<BR>Including: $path/$entry";
			include_once("$path/$entry");
		}
	}
	$d->close();
	return $entries;
}

?>