<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

/*
 * CMTKUser Object - Store User Information
 * The CMTK User Object loads and stores information for a user
 * 
 */

class CMTKUser extends CMTKPersistentObject {
    
    function __construct() {
        $this->InitBlankUser();
        //$this->LoadObjectInfo();
    }

    function InitBlankUser() {
        // Setup the info needed to persist this user to the database
        $this->SetTableName("cmtk_users");
        $this->SetIDField("user_guid");
        $this->SetIDValue(cmtk_GetUniqueID());
    }

    function __destruct() {
        // Show that this user was active
        if ($this->IsAuthenticated() == true) {
            $this->SetValue("last_activity_date", date(DATE_FORMAT));
        }
        $this->SaveObjectInfo();
    }

    function SetAsCurrentUser() {
        // When a user authenticates, set as the current user
        $_SESSION['CMTK_CURRENT_USER'] = $this;        
    }

    function LogOutUser() {
        $user_guid = $this->GetValue("user_guid", "");
        // Clear the data for this user?
        //$this->ClearValues();
        if ($user_guid == "") { return $auth; }
        if (isset($_SESSION[$user_guid . "_isAuthenticated"])) {
            $_SESSION[$user_guid . "_isAuthenticated"] = false;
        }
    }

    function AuthenticateUser($user_name_or_email, $user_pass){
        // Don't re auth if current user is the same and is logged in
        if (($user_name_or_email == $this->GetUserName() ||
            $user_name_or_email == $this->GetEmailAddress()) &&
            $this->IsAuthenticated() == true){            
            return true;
        }

        // Make sure the current user is logged out
        $this->LogOutUser();
        $this->ClearValues();
        $this->InitBlankUser();

        // Try to load the user
         if($this->LoadUserByNameOrEmail($user_name_or_email) == false) {
             // User doesn't exist
             return false;
         }

         // Make sure the user hasn't been deleted
         if ($this->GetValue("deleted", "false") == "true") {
             // User has been deleted
             return false;
         }

         // Make sure the user hasn't been disabled
         if ($this->GetValue("disabled", "false") == "true") {
             return false;
         }

        // Compare the md5 password to see if we have a match
        $md5_pw = md5($user_pass);
        if ($this->GetValue("password", "") == $md5_pw) {
            // Valid user who just logged in            
            // Set the flag to show this user has been authenticated
            $_SESSION[$this->GetValue("user_guid", "<INVALID GUID>") . "_isAuthenticated"] = true;
            $this->SetValue("last_login_date", date(DATE_FORMAT));            
            return true;
        }

        // Password didn't match        
        return false;
    }

    static function GetCurrentUser() {
         if (!isset($_SESSION['CMTK_CURRENT_USER']) == true || $_SESSION['CMTK_CURRENT_USER'] == null) {
            $user = new CMTKUser();
            $user->SetAsCurrentUser();
        }
        return $_SESSION['CMTK_CURRENT_USER'];
    }

    function IsAuthenticated() {
        $auth = false;
        $user_guid = $this->GetValue("user_guid", "");
        if ($user_guid == "") { return $auth; }
        if (isset($_SESSION[$user_guid . "_isAuthenticated"]) &&
            $_SESSION[$user_guid . "_isAuthenticated"] == "true") {
            $auth = true;
        }

        return $auth;
    }

    function LoadUserByNameOrEmail($user_name_or_email) {
        // Load the specified user
        $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", DEFAULT_SITE_ID));
        $user_name_or_email = mysql_escape_string($user_name_or_email);
        $user_pass = mysql_escape_string($user_pass);
        $sql = "SELECT * FROM cmtk_users WHERE site_id='$site_id' AND " .
            "(`key`='user_name' or `key`='user_email') AND `value`='$user_name_or_email'";
        $rs = cmtk_Query($sql);
        $user_guid = "";
        while ($record = mysql_fetch_assoc($rs)) {
            $user_guid = $record['user_guid'];
        }

        if ($user_guid == "") {
            cmtk_LogError("Can't Load Invalid User: $user_name_or_email", __FILE__, __LINE__);
            return false;
        }
        return $this->LoadUserByGUID($user_guid);
    }

    function LoadUserByGUID($user_guid) {
        // Load the specified user
        $this->SetValue('user_guid', $user_guid);
        return $this->LoadObjectInfo();
    }    

    function GetUserNameOrEmail() {
        // Return the user name or the email address if the user name is blank
        $ret = "";
        $ret = $this->GetUserName();
        if ($ret == "") {
            $ret = $this->GetEmailAddress();
        }
        return $ret;
    }

    static function DeleteUser($user_guid) {
        // Mark the specified user as deleted
        if ($user_guid  == "") { return false; }

        // Get the current user and make sure that they are allowed to delete
        // other users.
        $curr_user = CMTKUser::GetCurrentUser();
        if ($curr_user === false) { return false; }
        $delete_role = cmtk_GetConfigValue("delete_user_role", DELETE_USER_ROLE);
        if ($curr_user->IsInRole($delete_role) != true ) { return false; }

        // Load the user and mark it as deleted
        $usr = new CMTKUser();
        if ($usr->LoadUser($user_guid) == true && $curr_user) {
            // The user exists, delete it.
            $usr->SetValue("deleted", "true");
            $usr->SetValue("deleted_by", $curr_user->GetUserNameOrEmail());
            $usr->SetValue("deleted_on", date(DATE_FORMAT));
            $usr->SaveUserInfo();
        }
    }

    static function CreateNewUser($user_name, $user_email, $password,
        $account_type = "cmtk", $external_user = "") {
        // Check to see if the user exists
        if (CMTKUser::UserEMailExists($user_email) == true ||
            CMTKUser::UserNameExists($user_name) == true) {
            // User exists, return false
            return false;
        }

        // if anonymous creation is turned on, bypass this stuff
        $curr_user_name = "<OPEN SIGNUP>";
        if (cmtk_GetConfigValue("open_signup", OPEN_SIGNUP) != "true") {
            $create_role = cmtk_GetConfigValue("create_user_role", CREATE_USER_ROLE);
            $curr_user = CMTKUser::GetCurrentUser();
            if ($curr_user === false) { return false; }
            if ($curr_user->IsInRole($create_role) != true ) { return false; }
        }

        if ($account_type == "cmtk") {
            // Create the user in the database
            $user_guid = cmtk_GetUniqueID();
            $new_user = new CMTKUser();
            $new_user->SetValue('user_guid', $user_guid);
            $new_user->SetValue('user_name', $user_name);
            $new_user->SetValue('user_email', $user_email);
            $new_user->SetValue('password', MD5($password));
            $new_user->SetValue('account_type', $account_type);
            $new_user->SetValue('external_username', $external_user);
            $new_user->SetValue('account_created_on', date(DATE_FORMAT));
            $new_user->SetValue('account_created_by', $curr_user_name);
            $new_user->SaveUserInfo();
            return $new_user;
           
        } else {
            throw new Exception("Invalid Account Type: $account_type");
        }
        // If we get here, it didn't work, return false
        return false;
    }    

    static function UserNameExists($user_name) {
        // Check the users table for this user name
        $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", DEFAULT_SITE_ID));
        $user_name = mysql_escape_string($user_name);
        $sql = "SELECT COUNT(*) as cnt FROM cmtk_users WHERE site_id='$site_id' " .
            " AND `key`='user_name' AND `value`='$user_name'";
        $cnt = cmtk_QueryScalar($sql, "0");
        if ($cnt+0 > 0) {
            // The username already exists
            return true;
        }
        // The username does not exist
        return false;
    }

    static function UserEMailExists($user_email) {
        // Check the users table for this user name
        $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", DEFAULT_SITE_ID));
        $user_email = mysql_escape_string($user_email);
        $sql = "SELECT COUNT(*) as cnt FROM cmtk_users WHERE site_id='$site_id' " .
            " AND `key`='user_email' AND `value`='$user_email'";
        $cnt = cmtk_QueryScalar($sql, "0");
        if ($cnt+0 > 0) {
            // The user email already exists
            return true;
        }
        // The user email does not exist
        return false;
    }

    static function GetCurrentUserName() {
        $ret = "";
        $user = CMTKUser::GetCurrentUser();
        if ($user !== false) {
            $ret = $user->GetUserName();
        }

        return $ret;
    }

    function GetUserName() {
        return $this->GetValue("user_name", "");
    }

    function GetEmailAddress() {
        return $this->GetValue("user_email", "");
    }

    function GetRoles() {
        return $this->GetValue("roles[]", array());
    }

    function AddRole($role_name) {
        if ($role_name == "") { return false; }
        $this->SetValue('roles[]', $role_name);
        return true;
    }

    function IsInRole($role_name) {
        if (in_array($role_name, $this->GetValue("roles[]", array())) == true) {
            return true;
        }
        return false;
    }    
}

?>
