<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

/*
 * Base class that objects can use to inherit persistent values
 *
 * Need to override SaveValueToDatabase and LoadObjectInfo
 * to customize storage
 */

abstract class CMTKPersistentObject {
    protected $VALUES = array();
    protected $CHANGED_VALUES = array();
    protected $IDENTIFIER_FIELD = "object_id";


    function SetIDField($field_name) {
        $this->IDENTIFIER_FIELD = $field_name;
    }

    function GetIDField() {
        return $this->IDENTIFIER_FIELD;
    }

    function SetIDValue($id_value) {
        $id_field = $this->GetIDField();
        $this->SetValue($id_field, $id_value, false);
    }

    function GetIDValue() {
        $id_field = $this->GetIDField();
        if ($id_field == "") { return false; }
        return $this->GetValue($id_field, "");
    }

    function SetTableName($table_name) {
        $this->SetValue("cmtk_persistent_save_table", $table_name, false);
    }

    function GetTableName() {
        return $this->GetValue("cmtk_persistent_save_table", "cmtk_object_values");
    }
    
    function GetAllValues() {
        return $this->VALUES;
    }

    function GetValue($key, $default = "") {
        if (isset($this->VALUES[$key])) {
            return $this->VALUES[$key];
        }
        return $default;
    }
    
    function ClearValues() {
        // Clear the values array
        $this->VALUES = array();
        $this->CHANGED_VALUES = array();
    }

    function SetValueIfNotExists($key, $value, $set_value_dirty = true) {
        $val = $this->GetValue($key, "");
        if ($val != "") { return false; }        
        return $this->SetValue($key, $value, $set_value_dirty);
    }

    function SetValue($key, $value, $set_value_dirty = true) {
        $changed = false;
        if (substr($key, -2) == "[]") {
            // This is an array value, store it as such
            $arr = $this->VALUES[$key];
            if (!isset($arr)) {
                $arr = array();
            }
            if (!in_array($value, $arr)) {
                // Don't add a value twice
                $arr[] = $value;
                $changed = true;
            }
            $this->VALUES[$key] = $arr;
        } else {
            if (!isset($this->VALUES[$key]) || $this->VALUES[$key] != $value) {
                $changed = true;
                $this->VALUES[$key] = $value;
            }
        }
        
        if ($set_value_dirty == true && $changed == true) {
            $this->SetValueDirty($key);
        }
    }
    
    function SetValueDirty($key) {
        if(!array_key_exists($key, $this->CHANGED_VALUES)) {
             $this->CHANGED_VALUES[$key] = true;
        }
    }
 
    function LoadObjectInfo() {
        // Get the page info from the database
        $table_name = mysql_escape_string($this->GetTableName());
        $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", DEFAULT_SITE_ID));
        $id_field = mysql_escape_string($this->IDENTIFIER_FIELD);
        $id_value = mysql_escape_string($this->GetValue($id_field, ""));
        $sql = "SELECT * FROM `$table_name` WHERE `site_id`='$site_id' AND `$id_field`='$id_value'";        
        $rs = cmtk_Query($sql);
        if ($rs === false) { return false; }
        while ($record = mysql_fetch_assoc($rs)) {
            $this->SetValue($record["key"], $record["value"], false);
        }
        return true;
    }

    function SaveObjectInfo() {
        // Store the page info in the database
        $id_field = mysql_escape_string($this->IDENTIFIER_FIELD);
        $id_value = mysql_escape_string($this->GetValue($id_field, ""));
        foreach($this->VALUES as $key=>$value) {
            if(array_key_exists($key, $this->CHANGED_VALUES) == true) {
                // Only save a value if it has been changed
                $this->SaveValueToDatabase($key, $value);
            }
        }
        // Clear the changed values array
        $this->CHANGED_VALUES = array();

        return true;
    }

    private function SaveValueToDatabase($key="", $value="", $clear_value = true) {
         $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", DEFAULT_SITE_ID));
         $table_name = mysql_escape_string($this->GetTableName());
         $id_field = mysql_escape_string($this->IDENTIFIER_FIELD);
         $id_value = mysql_escape_string($this->GetValue($id_field, ""));
         if (substr($key, -2) == "[]" && is_array($value)) {
            // Clear the values for this array before saving it
            $sql = "DELETE FROM `$table_name` WHERE `site_id`='$site_id' AND" .
                " `$id_field`='$id_value' AND `key`='$key'";
            cmtk_Query($sql);
            // This is an array value, call this function recursively to save the array items.
            foreach ((array)$value as $tkey=>$tval) {
                if(!is_numeric($tkey) && strlen($tken) > 0) {
                    $key = $key . "_" . $tkey;
                }
                // Don't clear the value though as there will be multiples
                $this->SaveValueToDatabase($identifier_field1, $identifier_value1, $key, $tval, false, $table_name);
            }
        } else {
            // Save simple value
            // Clear this value
            if ($clear_value == true) {
                $sql = "DELETE FROM `$table_name` WHERE `site_id`='$site_id' AND" .
                    " `$id_field`='$id_value' AND `key`='$key'";
                cmtk_Query($sql);
            }

            // Add this value to the database
            $sql = "INSERT INTO `$table_name` (`site_id`, `$id_field`, `key`, `value`) " .
                " VALUES ('$site_id', '$id_value', " .
                "'" . mysql_escape_string($key) . "', " .
                "'" . mysql_escape_string($value) . "')";
            cmtk_Query($sql);
        }
    }
}


?>
