<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

/*
 * CMTK Form Part
 * This part is responsible for rendering, validating, and processing
 * pre defined forms
 */

class CMTKForm extends CMTKPart {

    protected $FORM_XML_DOCUMENT = null;

    function InitializePart($dom_element) {
        $ret = parent::InitializePart($dom_element);
        if ($ret == false) { return $ret; }

        // Load the form
        return $this->LoadForm();
    }

    function Render() {
        $ret = "";

        $name = $this->GetName();
        $tag_name = $this->GetTagName();

        if ($this->LoadForm() === false) {
            $ret = "[ CMTK Form Error ($name) Unable to load form XML file ]";
            return $ret;
        }
        
        $doc = $this->FORM_XML_DOCUMENT;
        if ($doc == null) {
            $ret = "[ CMTK Form Error ($name) XML Form not loaded ]";
            return $ret;
        }

        // Get the FORM tag
        $node_list = $doc->getElementsByTagName("CMTK_FORM");
        $form_tag = null;
        foreach($node_list as $form_tag) {
            // Render the form tag
            $ret .= $this->RenderForm($form_tag);
            break;
        }        

        return $ret;
    }

    function RenderForm($form_node) {
        global $CMTKForm_form_template_table;
        $ret = "";

        if ($form_node == null || $form_node === false) {
            return "<b>[ Invalid Form Node! ]</b>";
        }

        // Get the template to render the form with
        $form_template = $CMTKForm_form_template_table;
        $tmp = $form_node->getAttribute("render_template");
        if ($tmp != "") {
            $form_template = $tmp;
        }

        // Process the form inputs
        $form_template = $this->RenderFormInputs($form_template, $form_node);

        // Drop in the form values
        $attributes = $form_node->attributes;
        foreach($attributes as $key => $value) {
            $form_template = str_replace("{" . $key . "}", $value->textContent, $form_template);
        }

        $ret = $form_template;

        return $ret;
    }

    function RenderFormInputs($form_template, $form_node) {
        // Reference the input templates
        global $CMTKForm_input_template_text, $CMTKForm_input_template_password, $CMTKForm_input_template_radio;
        global $CMTKForm_input_template_checkbox, $CMTKForm_input_template_select, $CMTKForm_input_template_textarea;
        global $CMTKForm_input_template_submit, $CMTKForm_input_template_reset, $CMTKForm_input_template_button;
        global $CMTKForm_input_template_link_button, $CMTKForm_input_template_hidden;

        // Render the inputs for this form
        $ret = $form_template;

        // Extract the CMTK_INPUT_LIST from the template
        $list_str_start = stripos($form_template, "<CMTK_INPUT_LIST");
        if ($list_str_start === false) { return $ret; }
        $list_str_end = stripos($form_template, "</CMTK_INPUT_LIST>", $list_str_start);
        if ($list_str_end === false) { return $ret; }
        $list_str = substr($form_template, $list_str_start, $list_str_end + strlen("</CMTK_INPUT_LIST>") - $list_str_start);
        if ($list_str == "") { return $ret; }

        $input_str = "";
        $tmp = "";

        $node_list = $form_node->getElementsByTagName("CMTK_FORM_INPUT");
        foreach($node_list as $node) {
            // Apply the attributes for the current node to a fresh copy of the template string
            $tmp = $list_str;
            //cmtk_LogError("Input Node: " . $node->nodeName, __FILE__, __LINE__);

            $attributes = $node->attributes;
            foreach ($attributes as $key => $value) {
                $tmp = str_replace("{" . $key . "}", $value->textContent, $tmp);
            }

            // deal with default values
            $default_value = $node->getAttribute("input_default_value");
            // TODO: Adjust default value to get set value if this is post back

            // Render the actual input tag
            $input_template = $CMTKForm_input_template_text;
            $value_list = false;
            $tag_type = strtolower($node->getAttribute("input_type"));
            switch($tag_type) {
              case 'text':
                  $input_template = $CMTKForm_input_template_text;
                  break;
              case 'button':
                  $input_template = $CMTKForm_input_template_button;
                  break;
              case 'checkbox':
                  $input_template = $CMTKForm_input_template_checkbox;
                  //$value_list = GetInputValueList($record["id"], "checked");
                  break;
              case 'hidden':
                  $input_template = $CMTKForm_input_template_hidden;
                  break;
              case 'link_button':
                  $input_template = $CMTKForm_input_template_link_button;
                  break;
              case 'password':
                  $input_template = $CMTKForm_input_template_password;
                  break;
              case 'radio':
                  $input_template = $CMTKForm_input_template_radio;
                  //$value_list = GetInputValueList($record["id"], "checked");
                  break;
              case 'reset':
                  $input_template = $CMTKForm_input_template_reset;
                  break;
              case 'select':
                  $input_template = $CMTKForm_input_template_select;
                  //$value_list = GetInputValueList($record["id"], "selected");
                  break;
              case 'submit':
                  $input_template = $CMTKForm_input_template_submit;
                  break;
              case 'textarea':
                  $input_template = $CMTKForm_input_template_textarea;
                  break;
              default:
                  break;
            }            

            // Replace values in the input template
            $attributes = $node->attributes;
            foreach ($attributes as $key => $value) {
                $input_template = str_replace("{" . $key . "}", $value->textContent, $input_template);
            }

            // Replace the default value
            $input_template = str_replace("{input_value}", $default_value, $input_template);

            if($value_list) {
                //$input_template = ProcessList($input_template, $value_list, null, "VALUE_LIST");
            }
            $tmp = str_ireplace("{input_render}", $input_template, $tmp);
            
            $input_str .= $tmp;
        }

        $ret = str_replace($list_str, $input_str, $form_template);
        return $ret;
    }

    function LoadForm() {
        global $app_config_directory;
        // Determine form xml file name
        $file_name = strtolower(basename($this->GetValue("name", "")) . ".xml");
        $file_name = $app_config_directory . "/cmtk_forms/$file_name";
        if (!file_exists($file_name)) {            
            return false;
        }
        
        // Load the XML from the file
        $xml_str = file_get_contents($file_name);
        if ($xml_str === false || $xml_str == "") {
            return false;
        }

        $doc = new DOMDocument("1.0", "UTF-8");
        $doc->preserveWhiteSpace = true;
        $doc->strictErrorChecking = false;
        $doc->resolveExternals = false;

        if ($doc->loadXML($xml_str) === false) {
            cmtk_LogError("Error parsing page", __FILE__, __LINE__);
            return $ret;
        }

        $this->FORM_XML_DOCUMENT = $doc;

        return true;
    }
}


/*
 * Form Templates
 * These are the default templates used to render basic forms
 */

global $CMTKForm_form_template_table;
global $CMTKForm_input_template_text, $CMTKForm_input_template_password, $CMTKForm_input_template_radio;
global $CMTKForm_input_template_checkbox, $CMTKForm_input_template_select, $CMTKForm_input_template_textarea;
global $CMTKForm_input_template_submit, $CMTKForm_input_template_reset, $CMTKForm_input_template_button;
global $CMTKForm_input_template_link_button, $CMTKForm_input_template_hidden;

$CMTKForm_form_template_table = <<<EOT
<form action="{form_action}" method="{form_method}" id="{form_name}" name="{form_name}" on_submit="{form_on_submit}">
<table class="table">
    <caption>{form_title}</caption>
    <tbody>
<CMTK_INPUT_LIST>
       <tr>
            <td>{input_display_text}</td>
            <td>{input_render}</td>
            <td class="{input_required_class}">{input_required_field_indicator}</td>
        </tr>
</CMTK_INPUT_LIST>
    </tbody>
</table>
</form>
EOT;

$CMTKForm_input_template_text = <<<EOT
<input type="text" name="{input_name}" class="{input_class}" value="{input_value}"
 required="{input_required_field}" error_message="{input_validator_message}"
displayName="{input_display_text}"
 validationType="{input_validator}" on_click="{input_on_click}" on_blur="{input_on_blur}" />
EOT;

$CMTKForm_input_template_button = <<<EOT
<input type="button" name="{input_name}" class="{input_class}" value="{input_value}"
 on_click="{input_on_click}" />
EOT;

$CMTKForm_input_template_checkbox = <<<EOT
<input type="checkbox" name="{input_name}" class="{input_class}" value="{input_value}"
 required="{input_required_field}" error_message="{input_validator_message}" displayName="{input_display_text}"
 validationType="{input_validator}" on_click="{input_on_click}" on_blur="{input_on_blur}" {input_checked} />
EOT;

$CMTKForm_input_template_hidden = <<<EOT
<input type="hidden" name="{input_name}" class="{input_class}" value="{input_value}"
 required="{input_required_field}" error_message="{input_validator_message}" displayName="{input_display_text}"
 validationType="{input_validator}" on_click="{input_on_click}" on_blur="{input_on_blur}" />
EOT;

$CMTKForm_input_template_link_button = <<<EOT
<a href="#" onclick="{input_on_click}" id="{input_name}" name="{input_name}">{input_value}</a>
EOT;

$CMTKForm_input_template_password = <<<EOT
<input type="passworrd" name="{input_name}" class="{input_class}" value="{input_value}"
 required="{input_required_field}" error_message="{input_validator_message}" displayName="{input_display_text}"
 validationType="{input_validator}" on_click="{input_on_click}" on_blur="{input_on_blur}" />
EOT;

$CMTKForm_input_template_radio = <<<EOT
<CMTK_VALUE_LIST>
<input type="radio" name="{input_name}" class="{value_class}" value="{value_value}"
 required="{input_required_field}" error_message="{input_validator_message}" displayName="{input_display_text}"
 validationType="{input_validator}" on_click="{input_on_click}" {input_checked} /> {value_text}
</CMTK_VALUE_LIST>
EOT;

$CMTKForm_input_template_reset = <<<EOT
<input type="reset" name="{input_name}" class="{input_class}" value="{input_value}"
 on_click="{input_on_click}" />
EOT;

$CMTKForm_input_template_select = <<<EOT
<select name="{input_name}" class="{input_class}">
    <CMTK_VALUE_LIST><OPTION value="{value_value}" class="{value_class}" {selected}>{value_text}</OPTION>
    </CMTK_VALUE_LIST>
</select>
EOT;

$CMTKForm_input_template_submit = <<<EOT
<input type="submit" name="{input_name}" class="{input_class}" value="{input_value}"
 on_click="{input_on_click}" />
EOT;

$CMTKForm_input_template_textarea = <<<EOT
<textarea class="{input_class}" name="{input_name}">{input_value}</textarea>
EOT;

?>
