<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */



class CMTKEvent {

    static $EVENT_LIST = array();

    static function FireEvent($event_name, $event_args) {
        // If the default event function exists, fire it and pass it the args
        if (function_exists($event_name)) {            
            call_user_func($event_name, $event_args);
        }

        // Call any registered events
        //$key_str = sprintf(array_keys(CMTKEvent::$EVENT_LIST));
        if (key_exists($event_name, CMTKEvent::$EVENT_LIST)) {
            // Call each registered event
            $list = CMTKEvent::$EVENT_LIST[$event_name];            
            foreach ($list as $event) {                
                if (function_exists($event)) {
                    call_user_func($event, $event_args);
                } else {
                    cmtk_LogError("Event Functino ($event) does not exist - trying to call for event $event_name", __FILE__, __LINE__);
                }
            }
        }

    }

    static function AddEvent($event_name, $function_name) {
        $list = CMTKEvent::$EVENT_LIST[$event_name];
        if ($list == null) {
            $list = array();
        }
        if (!in_array($function_name, $list)) {
            $list[] = $function_name;
        }
        CMTKEvent::$EVENT_LIST[$event_name] = $list;
        return true;
    }

    static function RemoveEvent($event_name, $function_name) {
        if (!key_exists($event_name, CMTKEvent::$EVENT_LIST)) { return false; }
        $list = CMTKEvent::$EVENT_LIST[$event_name];
        if ($list == null) {
            $list = array();
        }
        $item = array_search($function_name, $list);
        if ($item !== false) {
            unset($list[$item]);
        }
        CMTKEvent::$EVENT_LIST[$event_name] = $list;
        return true;
    }
}

?>
