<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

// Need to load this now so we can load config values from the db
include_once "database.php";

// Load the user configs for use by the app

/*
 * 
 * Load the user config from the config folder
 */
function cmtk_LoadSiteConfig() {
    global $app_config_directory;
    unset($CMTK_CONFIG);
    if (isset($_SESSION["CMTK_CONFIG"])) {
        $CMTK_CONFIG = $_SESSION["CMTK_CONFIG"];
    }
   
    // Load the various config files
    if (!isset($CMTK_CONFIG) || $CMTK_CONFIG["config_loaded"] != "true") {        
        // Load the php configs, should get db settings to start with
        cmtk_IncludeFiles($app_config_directory);
        // Load the info in the db
        cmtk_LoadDBConfigSettings();
    }

    cmtk_SetConfigValue("config_loaded", "true");
    return true;
}

function cmtk_LoadDBConfigSettings() {
    // Db query to load the db settings.
    $site_id = mysql_escape_string(cmtk_GetConfigValue("site_id", "CMTK Website"));
    $sql = "SELECT * FROM cmtk_config WHERE `site_id`='$site_id'";
    $rs = cmtk_Query($sql);
    if ($rs === false) { return false; }
    while ($record = mysql_fetch_assoc($rs)) {        
        cmtk_SetConfigValue($record["key"], $record["value"]);
    }
    return true;
}

function cmtk_GetConfigValue($key, $default="") {
    if (!isset($_SESSION["CMTK_CONFIG"])) {
        $_SESSION["CMTK_CONFIG"] = array();
    }
    $CMTK_CONFIG = $_SESSION["CMTK_CONFIG"];
    if (isset($CMTK_CONFIG[$key])) {
        return $CMTK_CONFIG[$key];
    }
    return $default;
}

function cmtk_SetConfigValue($key, $value) {
    if (!isset($_SESSION["CMTK_CONFIG"])) {
        $_SESSION["CMTK_CONFIG"] = array();
    }
    $CMTK_CONFIG = $_SESSION["CMTK_CONFIG"];
    $CMTK_CONFIG[$key] = $value;
    $_SESSION["CMTK_CONFIG"] = $CMTK_CONFIG;
}

?>
