<?php
/*
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

/*
 * Component base class. CMTK Components should be derived from this
 * class.
 */

abstract class CMTKPart extends CMTKPersistentObject {    
    protected $GUID = null;
    protected $DOM_DOCUMENT_ELEMENT = null;

    function __construct() {
        $this->GUID = cmtk_GetUniqueID();
    }

    function __destruct() {
    }
    
    function GetTagName() {
        return $this->GetValue("tag_name", "");
    }

    function GetName() {
        return $this->GetValue("name", "");
    }

    function InitializePart($dom_element) {
        // Pull the information out of the dom object
        if ($dom_element == null) { return false; }

        // Save the DOM node
        $this->SetDomElement($dom_element);

        // Get the node value
        $this->SetValue("node_value", cmtk_DOMinnerHTML($dom_element));

        // Save the tag name
        $this->SetValue("tag_name", $dom_element->tagName);

        // Get the attributes
        $attributes_list = $dom_element->attributes;
        foreach($attributes_list as $attribute_name => $attribute_node) {            
            $this->SetValue($attribute_name, $attribute_node->textContent);
        }

        return true;
    }

    function GetDomElement() {
        return $this->DOM_DOCUMENT_ELEMENT;
    }

    function SetDomElement($dom_element) {
        $this->DOM_DOCUMENT_ELEMENT = $dom_element;
    }
    
}


?>
