// Validation code written by Computer Magic and Software Design
// Copyright � 2006
// rayp@cmagic.biz
// www.cmagic.biz
// Part of the Computer Magic Tool Kit (CMTK) at http://cmtk.cmagic.biz/

/* STEP 1:  To use this script, include it by adding the following line to your HEAD tag (note: adjust paths appropriatly)
<SCRIPT language="Javascript" src="http://cmtk.cmagic.biz/cmtk/js/validator.js"></SCRIPT>
*/

/* STEP 2:  On your form tag, after action="??" add the onsubmit handler
<FORM method="Post" action="test" name="MyForm" onsubmit="return Validate(this);">
....
</FORM>
*/

/* STEP 3:  Once your script is ready, you can add attributes to your inputs that will
			tell the script how to deal with them. For example, required will mean the script wont submit
			until the field has something entered in it.

*****NOTE: ThIs Is CaSe SeNsItIvE!!!

required="yes"	- This attribute makes the input a required field
		yes or true

errorMessage="Please fill this out.."  - This attribute allows you to enter a custom error message if this
		field isn't filled out. This will be in addition to the name of the input showing up.

displayName="Client Age"  - This attribute allows you to display a different name than the real name for
		the input. Input names are often ugly (e.g. a_full_name) and it would be nice for the error message
		to just say (Full Name).  This allows you to leave the real name of the input alone and still have the
		message look presentable to the user.

validationType="phone"  - This allows you to specify how to validate the input. The default is a simple check
		to make sure a value was entered (notempty). By changing this, you can validate email addresses, phone
		numbers, etc. This only works on text boxes and text areas.
			phone - Validate a phone number
			email - Validate an email address
			notempty - Just make sure they filled something in

*/

// ===========================================================================================================
// Code section, do not change.
// ===========================================================================================================

function Validate(frm) {
	inputs = frm.elements;
	for (i=0; i<inputs.length; i++ )
	{
		var input = inputs[i];
		// input.type == "checkbox"
		//alert(input.getAttribute("required"));
		if (!isUndefined(input.getAttribute("required")) && (input.getAttribute("required").toLowerCase() == "yes" || input.getAttribute("required").toLowerCase() == "true" || input.getAttribute("required") == true ))
		{
			// If we find an input that has problems, lets flag it
			if (!ValidateInput(input))
			{
				var msg = "Please fill out the required field: ";
				if (!isUndefined(input.getAttribute("displayName")))
				{
					msg += input.getAttribute("displayName");
				} else {
					msg += input.getAttribute("name");
				}

				if (!isUndefined(input.getAttribute("errorMessage")) && input.getAttribute("errorMessage") != null)
				{	msg += "\n" + input.getAttribute("errorMessage"); }

				alert(msg);
				input.focus();
				return false;
			}
		}
	}

	// Everything is ok, return true.
	return true;
}


function ValidateInput(input) {
	//alert(input.name + ":" + input.type);
	if (input.type=="text" || input.type=="textarea")	{
		if (input.value == "") {
			return false;
		}
		// Use a pattern to check where needed
		if (!isUndefined(input.getAttribute("validationType")))
		{
			var pattern = "";
			switch(input.getAttribute("validationType")) {
				case "phone": // phone num w or w out area code and dashes
					pattern = "(^[0-9]{3}[-][0-9]{4}$)|(^[0-9]{3}[-][0-9]{3}[-][0-9]{4}$)";
					break;
				case "phone11": // phone number with 11 digits
					pattern = "^([0-9]{11})$";
					break;
				case "email":
					pattern = "^[a-zA-Z\-_0-9\.]+@[a-zA-Z\-_0-9\.]+$";
					break;
				case "email2":	// another way to math email
					pattern = "^([\w]+)(.[\w]+)*@([\w]+)(.[\w]{2,3}){1,2}$";
					break;
				case "date": // Date in the format dd/mm/yyyy
					pattern = "^([0-9]){2}(\/|-){1}([0-9]){2}(\/|-){1}([0-9]){4}$";
					break;
				default:
					pattern = "";
					break;
//validate="/[\d\w]{3,}/" - the data must be at least 3 characters long,and should include letters or digits
			}
			if (pattern != "") {
				// NOTE: if you use getattribute here, you get the original value in firefox, not the current one!
				var match = input.value.match(pattern);
				if (match == null)
				{
					return false;
				}
			}
		}
	}else if (input.type=="checkbox") {
		if (input.checked != true) {
			return false;
		}
	}else if (input.type=="radio") {
	}else if (input.type=="file") {
		if (input.value=="") {
			return false;
		}
	}else if (input.type=="select-one" || input.type=="select")	{
		if (input.value=="") {
			return false;
		}
	}
	return true;
}










function isAlien(a) {
   return isObject(a) && typeof a.constructor != 'function';
}
function isArray(a) {
    return isObject(a) && a.constructor == Array;
}
function isBoolean(a) {
    return typeof a == 'boolean';
}
function isEmpty(o) {
    var i, v;
    if (isObject(o)) {
        for (i in o) {
            v = o[i];
            if (isUndefined(v) && isFunction(v)) {
                return false;
            }
        }
    }
    return true;
}
function isFunction(a) {
    return typeof a == 'function';
}
function isNull(a) {
    return typeof a == 'object' && !a;
}
function isNumber(a) {
    return typeof a == 'number' && isFinite(a);
}
function isObject(a) {
    return (a && typeof a == 'object') || isFunction(a);
}
function isString(a) {
    return typeof a == 'string';
}
function isUndefined(a) {
	var ret = false;
	if (ret == null) {
		ret = true;
	}
	if (typeof a == 'undefined') {
		ret = true;
	}
    return ret;
}
