<?php
/* 
 * Computer Magic Tool Kit (CMTK)
 * Copyright 2006 Computer Magic and Software Design.
 * All rights reserved.
 */

// Global variables used by the system

// Folder where the config files are located
global $app_config_directory;
if (!isset($app_config_directory)) {
    $app_config_directory = $app_directory . "/cmtk_config";
}

// Setup template folder
global $app_template_directory;
if (!isset($app_template_directory)) {
    $app_template_directory = $app_config_directory . "/templates";
}

// Clear the template file if the file doesn't exist
global $template_file;
if (strlen($template_file) < 1 || !file_exists($app_template_directory . "/" . $template_file)) {
	// Invalid templates folder! Clear the file name so we don't bother trying...
	$template_file = "";
}


//TODO: Take over echo
// http://us3.php.net/manual/en/function.override-function.php

// Set the default exception handler
set_exception_handler('cmtk_ExceptionHandler');

// Load the libs
global $cmtk_directory;
$cmtk_directory = dirname(__FILE__);
$lib_dir = $cmtk_directory . "/lib";
include_once $lib_dir . "/default_values.php";
include_once $lib_dir . "/utility.php";
include_once $lib_dir . "/config_loader.php"; // Auto loads site configs
include_once $lib_dir . "/database.php";
include_once $lib_dir . "/persistent_object.php";
include_once $lib_dir . "/cmtk_part.php";
include_once $lib_dir . "/events.php";
include_once $lib_dir . "/roles.php";
include_once $lib_dir . "/user.php";
include_once $lib_dir . "/page.php";
//include $lib_dir . "/";

// Load nusoap unless it is disabled
if (cmtk_GetConfigValue("load_nusoap", "true") == "true") {
    include $lib_dir . "/3rdParty/nusoap/lib/nusoap.php";
}

// Register the CMTK Class Autoload function
spl_autoload_register("cmtk_autoload");

/*
 * Startup and Init section
 * Do required module startup and init.
 * Do init here so that the classes can be defined and the session
 * started afterwards. DON'T run code before this as some items aren't
 * loaded yet (e.g. sessions not started)
 */
// Auto start the session
session_start();

// If reset is on, clear the session/configs
if (cmtk_GetReqValue("reset_session", "false") == "true") {
    $_SESSION = array();
    //session_unset();
    session_destroy();
    
    // Redirect to this page w out the reset_session value
    $protocol = "http://";
    if ($_SERVER["HTTPS"] == "on") {
        $protocol = "https://";
    }
    header("Location:  $protocol$_SERVER[HTTP_HOST]$_SERVER[PHP_SELF]");
    exit;
}

// Make sure we load it from the session or start a new one
cmtk_LoadSiteConfig();

// PAGE INIT
// Create the page object or load the current object if it is for this page
global $CMTK_CURRENT_PAGE;
$CMTK_CURRENT_PAGE = null;
if (isset($_SESSION["CMTK_CURRENT_PAGE"])) {
    $CMTK_CURRENT_PAGE = $_SESSION["CMTK_CURRENT_PAGE"];
    // Confirm that the URL matches, if not, clear it
    if ($CMTK_CURRENT_PAGE->GetPageURL() != CMTKPage::GetCurrentURL()) {
        $CMTK_CURRENT_PAGE = null;
    }
}
if ($CMTK_CURRENT_PAGE == null) {
    cmtk_LogError("Creating new page object (" . CMTKPage::GetCurrentURL() . ")", __FILE__, __LINE__);
    $CMTK_CURRENT_PAGE = new CMTKPage();    
}
$_SESSION["CMTK_CURRENT_PAGE"] = $CMTK_CURRENT_PAGE;

// Setup function to render the page at the end of each call
if (is_object($CMTK_CURRENT_PAGE)) {
    ob_start(array( &$CMTK_CURRENT_PAGE, 'RenderPage' ));
}



function cmtk_ExceptionHandler($ex) {
    $_SESSION['EXCEPTION'] = $ex;
    cmtk_LogError("Uncaught Exception: " . $ex->getMessage() . "<br />" . $ex->getTraceAsString(), $ex->getFile(), $ex->getLine());
    // TODO: Finish dummy exception handler
    echo "Unexpected System Error Encountered! Please try again later. <a href='/'>Return to Home Page</a>";
}

function cmtk_autoload($object_name) {
    global $cmtk_directory, $app_config_directory;

    if (class_exists($object_name)) {
        // Class already exists, don't load it
        // Should never get here?
        return true;
    }

    // Use the $src value if it exists, otherwise check the
    // built-in and default parts folders
    $inc_file = basename($object_name) . ".php";

    // Try to determine the path of this component
    if (file_exists( $app_config_directory . "/parts/" . basename($inc_file))) {
        // Load the part from the config folder
        $inc_file = $app_config_directory . "/parts/" . basename($inc_file);
    } elseif (file_exists( $cmtk_directory . "/lib/parts/" . basename($inc_file))) {
        // Load the part from the lib parts folder
        $inc_file = $cmtk_directory . "/lib/parts/" . basename($inc_file);
    } else {
        // File doesn't exist, clear it
        $inc_file = "";
    }

    // Try to load the component
    if ($inc_file == "") {
        cmtk_LogError("Unable to auto include file for $object_name", __FILE__, __LINE__);
        return false;
    }
    @include $inc_file;
    return true;
}

?>
